#include <windows.h>
#include <tchar.h>
#include <conIO.H>

#pragma warning(push, 2)
#include <string>
#include <VECTOR>
using std::string;
using std::vector;
#pragma warning(pop)

#include "RecurseDir.h"

//////////////////////////////////////////////////////////////////////////
//
// derived class which implements a filter
//
class CTest : public CDirectoryContent
{
public:
	explicit CTest(LPCTSTR pFilter) : m_filter(pFilter)
	{
	}

	virtual bool CheckUseFile (LPCTSTR , WIN32_FIND_DATA* pwfd ) 
	{
		return ::PathMatchSpec(pwfd->cFileName, m_filter.c_str()) != FALSE;
	}

	void dump()
	{
		for(arraytype::iterator i = List().begin(); i != List().end(); ++i)
			cprintf(_T("%s\t%i bytes\n"), (*i).cFileName, (*i).nFileSizeLow);
	}

private:
	std::string m_filter;
};



int main(int argc, char* argv[])
{
	if(argc == 2)
	{
		TCHAR	szCurrentDir[MAX_PATH];
		::GetCurrentDirectory(MAX_PATH, &szCurrentDir[0]);

		CTest	dir(argv[1]);

		if(dir.Run(szCurrentDir))
			dir.dump();
		else
			cputs(_T("Run() failed"));

	}
	else
	{
		cputs(_T("usage: RecurseDirText.exe filespec\n e.g.: RecurseDirTest.exe *.bmp"));
	}

	//
	// uncomment this to recursively delete the directory given as parameter 
	//
	/*
	
	  CCleanDir rd;
	  rd.Run(argv[1]);

	*/

	return 0;
}
